/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CThreadImpDrvNT.cpp,v 1.1 1999/09/12 04:33:34 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CThreadImpDrvNT.h"

_USING_PGP

// Class CThreadImpDrvNT member functions

CComboError 
CThreadImpDrvNT::StartOsThread()
{
	CComboError	error;

	error.err = PsCreateSystemThread(&mThreadHandle, THREAD_ALL_ACCESS, 
		NULL, NULL, NULL, MainThreadFunction, this);

	if (error.HaveNonPGPError())
		error.pgpErr = kPGPError_ThreadOpFailed;

	return error;
}

void 
CThreadImpDrvNT::MainThreadFunctionAux()
{
	KeSetPriorityThread(KeGetCurrentThread(), LOW_REALTIME_PRIORITY);

	while (TRUE)
	{
		__try 
		{
			// Call the main loop function.
			if (!MainThreadLoop())
				break;
		}
		__except(EXCEPTION_EXECUTE_HANDLER) 
		{
			pgpDebugMsg("Uncaught exception in PGPdisk thread!");
		}
	}

	PsTerminateSystemThread(STATUS_SUCCESS);
}

void 
CThreadImpDrvNT::MainThreadFunction(PVOID StartContext)
{
	CThreadImpDrvNT	*pThreadImpDrvNT	= 
		static_cast<CThreadImpDrvNT *>(StartContext);

	pgpAssertAddrValid(pThreadImpDrvNT, CThreadImpDrvNT);
	pThreadImpDrvNT->MainThreadFunctionAux();
}
